/**
* Copyright (C) 2012, Crestron Electronics, Inc.  All rights reserved.
* No part of this software may be reproduced in any form, machine or natural,
* without the express written consent of Crestron.
*
* \file     (See the name of this file).
* \brief    (See comments in the associated header file).
* \detail   (None).
* \warning  (None).
* \note     (None).
* \author   Arto Kiremitdjian.
* \date     3/23/2012.
* \review   Richard Ting on 3/27/12: rev. 138457.
**/
//-------------------------------------------------------------------------
// Include files.
#include <linux/gpio.h>
#include <linux/mutex.h>
#include <linux/workqueue.h>
#include "IrdHwSignals.h" // What class to implement.

//-------------------------------------------------------------------------
// Preprocessor defines.

//-------------------------------------------------------------------------
// Type definitions.

//-------------------------------------------------------------------------
// Local data/variables (declarations and definitions).

//-------------------------------------------------------------------------
// Local function declarations.

//-------------------------------------------------------------------------
// Local function definitions.


/**
* \brief    De-initializer.  Performs clean-up.
* \detail   Upon success, IR transceiver is in reset, and IR I/O h/w is off.
* \param    (None).
* \return   (None).
* \author   Arto Kiremitdjian.
* \date     3/23/2012
*/
void hwSignalsCleanUp (struct IRD_chip *chip)
{
    //printk(KERN_DEBUG "+%s.\n", __FUNCTION__);

    // Restore h/w signals to the same state as when they were initialized.
    Reset(chip,1); // Result IGNORED.
    IoPower(chip, 0); // Result IGNORED.

    //printk(KERN_DEBUG "-%s.\n", __FUNCTION__);
}

/**
* \brief    Control the state of h/w signal "IR_PWR_CTRL".
* \detail   (None).
* \param    powerOn - intean: Whether to power-on the IR I/O h/w.
* \return   intean: Whether this function succeeded.
* \author   Arto Kiremitdjian.
* \date     3/23/2012
*/
int IoPower (struct IRD_chip *chip, int const powerOn)
{
    //printk(KERN_ERR "+%s(%u).\n", __FUNCTION__, (unsigned int)powerOn);

    if(powerOn)
    	resumePin(chip->pdata->power);
    else
    	suspendPin(chip->pdata->power);

    //printk(KERN_ERR "-%s.\n", __FUNCTION__);
    return true;
}

/**
* \brief    Control the state of h/w signal "IR_RST_N".
* \detail   (None).
* \warning  CAUTION: Does not necessarily perform a full reset sequence,
*            nor a full "out-of-reset" sequence, for the IR transceiver.
*            Only provides low-level control of the reset signal itself.
* \param    inReset - intean: Whether to put the IR transceiver in reset.
* \return   intean: Whether this function succeeded.
* \author   Arto Kiremitdjian.
* \date     3/23/2012
*/
int Reset (struct IRD_chip *chip, int const inReset)
{
    //printk(KERN_ERR "+%s(%u).\n", __FUNCTION__, (unsigned int)inReset);

    if(inReset)
    	suspendPin(chip->pdata->reset);
    else
    	resumePin(chip->pdata->reset);


    //printk(KERN_ERR "-%s.\n", __FUNCTION__);
    return true;
}


